#
#	MBsysTran - Release 8.1
#
#	Copyright 
#	Universite catholique de Louvain (UCLouvain) 
#	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
#	2, Place du Levant
#	1348 Louvain-la-Neuve 
#	Belgium 
#
#	http://www.robotran.be 
#
#	==> Generation Date: Wed Apr 20 17:10:05 2022
#
#	==> Project name: five_point_suspension_c
#
#	==> Number of joints: 16
#
#	==> Function: F7 - Link Forces (1D)
#
#	==> Git hash: 220d76a94da8547597795a13c9921f0375de3fc1
#

from math import sin, cos, sqrt

def link(frc, trq, Flink, Z, Zd, s, tsim):
    q = s.q
    qd = s.qd
 
# Trigonometric functions

    S10 = sin(q[10])
    C10 = cos(q[10])
    S11 = sin(q[11])
    C11 = cos(q[11])
 
# Augmented Joint Position Vectors

 
# Link Kinematics: displacement (Z) , relative velocity (Zd)

    ROlnk2_211 = C10*S11
    ROlnk2_311 = S10*S11
    ROlnk2_511 = C10*C11
    ROlnk2_611 = S10*C11
    OMlnk2_22 = -qd[11]*S10
    OMlnk2_32 = qd[11]*C10
    RLlnk2_13 = -s.dpt[2,13]*S11
    RLlnk2_23 = ROlnk2_511*s.dpt[2,13]
    RLlnk2_33 = ROlnk2_611*s.dpt[2,13]
    POlnk2_13 = RLlnk2_13+s.dpt[1,6]
    POlnk2_23 = RLlnk2_23+s.dpt[2,6]
    POlnk2_33 = RLlnk2_33+s.dpt[3,6]
    ORlnk2_13 = OMlnk2_22*RLlnk2_33-OMlnk2_32*RLlnk2_23
    ORlnk2_23 = -qd[10]*RLlnk2_33+OMlnk2_32*RLlnk2_13
    ORlnk2_33 = qd[10]*RLlnk2_23-OMlnk2_22*RLlnk2_13
    Plnk11 = POlnk2_13-s.dpt[1,7]
    Plnk21 = POlnk2_23-s.dpt[2,7]
    Plnk31 = POlnk2_33-s.dpt[3,7]
    PPlnk1 = Plnk11*Plnk11+Plnk21*Plnk21+Plnk31*Plnk31
    Z1 = sqrt(PPlnk1)
    e11 = Plnk11/Z1
    e21 = Plnk21/Z1
    e31 = Plnk31/Z1
    Zd1 = ORlnk2_13*e11+ORlnk2_23*e21+ORlnk2_33*e31

# Link Forces 

    Flink1 = s.user_LinkForces(Z1,Zd1,s,tsim,1)
 
# Link Dynamics: forces projection on body-fixed frames

    fPlnk11 = Flink1*e11
    fPlnk21 = Flink1*e21
    fPlnk31 = Flink1*e31
    trqlnk1_1_1 = -fPlnk21*s.dpt[3,7]+fPlnk31*s.dpt[2,7]
    trqlnk1_1_2 = fPlnk11*s.dpt[3,7]-fPlnk31*s.dpt[1,7]
    trqlnk1_1_3 = -fPlnk11*s.dpt[2,7]+fPlnk21*s.dpt[1,7]
    fSlnk11 = Flink1*(ROlnk2_211*e21+ROlnk2_311*e31+e11*C11)
    fSlnk21 = Flink1*(ROlnk2_511*e21+ROlnk2_611*e31-e11*S11)
    fSlnk31 = Flink1*(-e21*S10+e31*C10)
    trqlnk11_1_1 = -fSlnk31*(s.dpt[2,13]-s.l[2,11])
    trqlnk11_1_3 = fSlnk11*(s.dpt[2,13]-s.l[2,11])
 
# Symbolic model output

    frc[1,1] = s.frc[1,1]+fPlnk11
    frc[2,1] = s.frc[2,1]+fPlnk21
    frc[3,1] = s.frc[3,1]+fPlnk31
    trq[1,1] = s.trq[1,1]+trqlnk1_1_1
    trq[2,1] = s.trq[2,1]+trqlnk1_1_2
    trq[3,1] = s.trq[3,1]+trqlnk1_1_3
    frc[1,11] = s.frc[1,11]-fSlnk11
    frc[2,11] = s.frc[2,11]-fSlnk21
    frc[3,11] = s.frc[3,11]-fSlnk31
    trq[1,11] = s.trq[1,11]+trqlnk11_1_1
    trq[3,11] = s.trq[3,11]+trqlnk11_1_3
 
# Symbolic model output

    Z[1] = Z1
    Zd[1] = Zd1
    Flink[1] = Flink1

# Number of continuation lines = 0


